# oneway_power.R
# Power analysis for one-way ANOVA

# Load necessary libraries
library(ggplot2)

# H1 means, sample sizes, standard deviation, alpha
groupmeans <- c(20,22,22,25,18)
nvals <- 2:20
stddev <- 3
alpha <- 0.05

# Power analysis
powout <- power.anova.test(groups = length(groupmeans),n=nvals,
between.var=var(groupmeans),within.var=stddev^2,sig.level=alpha)
powout

# Make data frame from power output
n <- powout$n
power <- powout$power
powdata <- as.data.frame(cbind(n,power))

# Print data
powdata

# Plot power vs. sample size
ggplot(powdata,aes(n,power))+
geom_line(color="black",size=1)+
geom_point(color="black",size=4)+
ggtitle("Power for one-way ANOVA")

